/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef GUI_MINIMAL_H
#define GUI_MINIMAL_H

#include "config_handler.h"
#include "numpad.h"
#include "rf_system.h"
#include "rf_system_minimal.h"
#include "loggingclass.h"
#include <QMainWindow>
#include <QButtonGroup>
//#include <QMap>
#include <QPushButton>
#include <QTcpServer>
#include <QTcpSocket>
#include <QThread>
#include <QTimer>
#include <QtSerialPort/QSerialPort>

namespace Ui {
class GUI_Minimal;
}

class GUI_Minimal : public QMainWindow
{
	Q_OBJECT

public:
	explicit GUI_Minimal(QWidget *parent = nullptr);
	~GUI_Minimal();

signals:
	void signal_channelInit(int intrasys_num);
	void signal_timerStart(int intrasys_num, int ms);
	void signal_timerStop(int intrasys_num);

	void signal_execute_reset_SGx(int intrasys_num);
	void signal_execute_error_clear(int intrasys_num);
	void signal_set_error_clearing_enable(int intrasys_num, bool enable);

	void signal_RF_enable(int intrasys_num, bool enable);
	void signal_request_PA_power_update(int intrasys_num);

	void signal_set_power_control_mode(int intrasys_num, int mode);
	void signal_setPowerWatt(int intrasys_num, double power_watt);
	void signal_setPowerdBm(int intrasys_num, double power_dbm);
	void signal_setFrequency(int intrasys_num, double frequency);

private slots:

//	void handler_execute_restart_program();
//	void handler_notification_get(int intrasys_num, QString notification);
	void handler_channel_working(int channel_number, bool enabled);
	void handler_channel_init_failed(int intrasys_num);

	void handler_firmware_version_get(int intrasys_num, int channel_num, QString version);
	void handler_error_get(int intrasys_num, quint64 error, QStringList error_messages);
	void handler_reset_detected(int intrasys_num, int channel_number);
	void handler_temperature_get(int intrasys_num, double temperature);

	void handler_RF_enable_get(int intrasys_num, bool RF_enabled);
	void handler_PA_power_readings(int intrasys_num, double PA_power_fwd_dbm, double PA_power_rfl_dbm, double PA_s11, double PA_power_fwd_watt, double PA_power_rfl_watt, double PA_s11_reflection);
	void handler_power_get(int intrasys_num, double power_dbm, double power_watt);
	void handler_frequency_get(int intrasys_num, double frequency_mhz);

	//Data Logging
//	void handler_datalogging_enable_get(bool enable);
//	void handler_datalogging_storage_sufficient(bool valid);
//	void handler_datalogging_log_deleted(bool success, QString filename);
//	void handler_datalogging(bool enable);

	void on_pushButton_RF_OFF_1_clicked();
	void on_pushButton_RF_ON_1_clicked();

	void on_pushButton_frequency_1_clicked();
	void on_pushButton_power_watt_1_clicked();

	//Numpad Buttons
	void on_numpadButton_0_clicked();
	void on_numpadButton_1_clicked();
	void on_numpadButton_2_clicked();
	void on_numpadButton_3_clicked();
	void on_numpadButton_4_clicked();
	void on_numpadButton_5_clicked();
	void on_numpadButton_6_clicked();
	void on_numpadButton_7_clicked();
	void on_numpadButton_8_clicked();
	void on_numpadButton_9_clicked();
	void on_numpadButton_period_clicked();
	void on_numpadButton_arrow_left_clicked();
	void on_numpadButton_arrow_right_clicked();
	void on_numpadButton_plus_clicked();
	void on_numpadButton_minus_clicked();
	void on_numpadButton_backspace_clicked();
	void on_numpadButton_clear_all_clicked();
	void on_numpadButton_ok_clicked();

	//Numpad Functions
	void numpad_value_confirmed_handler(QPushButton *button, double *num);

	//RCM
	void on_pushButton_remote_command_USB_1_clicked();


private:
	Ui::GUI_Minimal *ui;

	RF_System_Minimal *RF_system_constructor;
	ConfigHandler *config;

	double numpad_value = 0;

	/* CORE */
	QSerialPort SG_port;
	QSerialPort RCM_port;
	QTcpServer *tcpServer = nullptr;
	QTcpSocket *tcpSocket = nullptr;
	QString channel_select = "1";
	StatusCheck *status_checker;

	/* Transparent Mode */
	void handler_RCM_mode();
	bool RCM_supported = false;
	int remote_command_mode = 0;	//0 = OFF, 1 = UART/USB, 2 = TCP
	QString ipAddress;				//IP Address of this system

	/* Startup functions */
	void firmware_version_check(QString firmware_version);
	int	firmware_version_requirement[4];
	QString	toolkit_GUI_version;

	/* Miscellaneous */
	void configure_auto_error_clearing();

	QButtonGroup buttonGroup_RF_Enable;

	/* Datalogging */
	LoggingClass *datalogger;

	/* NUMPAD */
	/* target_parameter and target_button can be used to 'dynamically' refer to the most recently pressed 'control button' and accompanying relevant variable, on any of the pages.
	 * precision is used to decide how many decimals will be used.
	 * multiplier is for swapping between for example Hz and MHz.
	 * The contents of these four can be changed by using the numpad_preparation function below. */
	Numpad *numpad;
	QPushButton *target_parameter_button;
	double scale_multiplier;
	int precision;

	void numpad_parameter_select(QPushButton *button, double *parameter, QString unit, int precision = 2, double scale = 1, bool period_enable = true, bool sign_enable = false);


};

#endif //GUI_MINIMAL_H

